import numpy as np
import matplotlib.pyplot as plt

def plot_free_energy_diagram(inis, ts, fs, name):
    x = [1,2,2.5,3.5, 4,5]
    y = [0, 0, ts - inis, ts - inis, fs -inis, fs - inis]
    plt.plot(x,y,label=name)
    plt.ylabel(r"$\Delta G$ [eV]")
    plt.xticks(ticks = [1.5, 3, 4.5], labels= ["IS", "TS", "FS"])
    plt.legend()

def add_arrows(state, e1, e2):
    if state == 'IS':
        x = 1.5
    elif state == "TS":
        x = 3
    else:
        x = 4.5
    plt.annotate('', xy=(x, e2), xytext=(x, e1),
             arrowprops=dict(facecolor='green', shrink=0.05))
    plt.text(x + 0.1, 0.5 * (e1 + e2), f"{e2 - e1:.2f} eV")

# Load precomputed energies
energies = np.load('results/energies.npy', allow_pickle=True).item()
potentials = [0, -0.6]

# print summary
print()
print("# ---------------------Reaction Energies---------------------")
print(f"{'potential':<10} {'forward barrier':>16} {'backward barrier':>16} {'reaction energy':>16}")
print("-" * 61)
for potential in potentials:
    # get the computed IS, TS and FS total (Grand) energies obtained at this potential
    IS = energies[f'IS_{potential}VSHE']
    TS = energies[f'TS_{potential}VSHE']
    FS = energies[f'FS_{potential}VSHE']
    # compute reaction energy and forward and backward barrier
    reaction_energy = 
    forward_barrier = 
    backward_barrier = 
    print(f"{potential:<10} {forward_barrier:>16.3f} {backward_barrier:>16.3f} {reaction_energy:>16.3f}")

    # plot free energy diagram
    plot_free_energy_diagram(IS, TS, FS, name = "{}V vs. SHE".format(potential))

# add arrows highlighting the changes
add_arrows(state='TS', e1 = energies['TS_0VSHE'] - energies['IS_0VSHE'], e2 = energies['TS_-0.6VSHE'] - energies['IS_-0.6VSHE'])
add_arrows(state='FS', e1 = energies['FS_0VSHE'] - energies['IS_0VSHE'], e2 = energies['FS_-0.6VSHE'] - energies['IS_-0.6VSHE'])
plt.show()
